	% Example 12.1  
	clear all
	close all,clc
	r = 0.15; Amax =-10*log10(1-r^2); Amin = 40;
	wcT = 0.25*pi; wsT = 0.35*pi; 	wac = tan(wcT/2); was = tan(wsT/2);
	N = CA_ORDER_S(wac, was, Amax, Amin);
	N = 5;	
	[G, Z, R_ZEROS, P, wsnew] = CA_POLES_S(wac, was, Amax, Amin, N);	
 	[S1num, S1den, S2num, S2den] = SORT_LATTICE_POLES_LP_S(P);
	[Xnum, Xden] = S_2_X(S1num, S1den)    % Reactance for a reflectance
	[L, C, K] = X_CAUER_I(Xnum, Xden)	% Element values
	
	% Compute port resistances for X1
	R3 = L(1); G4 = C(2); R5 = L(3); G5 = 1/R5;
	% Compute the adaptor coefficients
	% Adaptor III	
	G6 = G4 + G5;	R6 = 1/G6;
	alfa31 = 2*G4/(G6 + G4 + G5)
	alfa32 = 2*G6/(G6 + G4 + G5)
	alfa33 = 2*G5/(G6 + G4 + G5)
	% Adaptor II
	alfa21 = 2*1/(R6 + R3 + 1)
	alfa22 = 2*R3/(R6 + R3 + 1)
	alfa23 = 2*R6/(R6 + R3 + 1)
	%==========================================
	[Xnum, Xden] = S_2_X(S2num, S2den);
	[L, C, K] = X_CAUER_I(Xnum, Xden)
	
 	% Compute port resistances for X2
	R1 = L(1);	R2 = 1/C(2);	R3 = 1;	
	
	% Adaptor I
	alfa11 = 2*R1/(R1 + R2 + R3)
	alfa12 = 2*R2/(R1 + R2 + R3)
	alfa13 = 2*R3/(R1 + R2 + R3)
	a1 = 1; v1 = 0; v2 = 0; v3 = 0; v4 = 0;	v5 = 0;
	for n = 1:20
		% Even
		A0 = -v1 + v2 + a1;
		v1 = -v1 - alfa11*A0;
		v2 = v2 - alfa12*A0;
		x1 = -(A0 + v1 + v2);
		% odd
		Temp1 = -v4 - v5;
		Temp2 = -alfa31*Temp1;
		x2 = Temp2 - v4;
		A0 = a1 + x2 - v3;
		x3 = a1 - alfa21*A0;
		v3 = -v3 - alfa22*A0;
		u2 = -(A0 + x3 + v3);		
		v4 = Temp2 + u2;
		v5 = Temp1 + v4;
		a1 = 0;
		h(n) = 0.5*(x1-x3);
	end
	figure(1), PLOT_IMPULSE_RESPONSE_Z(h)		
	[G, Z, P] = IMPULSE_2_P_Z(h, 5);
	figure(2), PLOT_PZ_Z(Z, P)
	wT = [0:0.001:pi];
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	Att = PZ_2_ATT_Z(G, Z, P, wT); 
	axis_Amax = 60; axis_Tg_max= 30;
	figure(3), PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)		
	grid on
	zoom on
		
